/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.collect.Sets;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.Util;
import cz.insophy.inplan.util.ChangeTrackingSet;
import cz.insophy.inplan.util.DefaultChangeTrackingSet;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.UnmodifiableChangeTrackingSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OperationDependencyFilter
extends Processor {
    private boolean checkAll;
    private Set<Operation> planneableOps;
    private Set<Operation> planneableOpsView;

    public OperationDependencyFilter() {
        DefaultChangeTrackingSet<Operation> planneableOps = DefaultChangeTrackingSet.create();
        this.planneableOps = planneableOps;
        this.planneableOpsView = new UnmodifiableChangeTrackingSet<Operation>(planneableOps);
        this.checkAll = false;
    }

    @Override
    public void setSuccessors(List<Processor> successors) {
        super.setSuccessors(successors);
        this.checkOneSuccessor();
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        if (!(ops instanceof ChangeTrackingSet)) {
            throw new IllegalArgumentException("An instance of " + ChangeTrackingSet.class + " expected.");
        }
        ChangeTrackingSet.Changes changes = ((ChangeTrackingSet)ops).getChanges();
        if (!this.checkAll) {
            for (Operation addedOp : changes.getAdded()) {
                if (!OperationDependencyFilter.isPlanneable(addedOp)) continue;
                this.planneableOps.add(addedOp);
            }
            HashSet<Operation> possiblyClearedOps = Sets.newHashSet();
            for (Operation removedOp : changes.getRemoved()) {
                if (removedOp.isPlanned()) {
                    possiblyClearedOps.addAll(removedOp.getSuccessors());
                }
                this.planneableOps.remove(removedOp);
            }
            possiblyClearedOps.retainAll(ops);
            for (Operation op : possiblyClearedOps) {
                if (!OperationDependencyFilter.isPlanneable(op)) continue;
                this.planneableOps.add(op);
            }
        } else {
            HashSet<Operation> toRemove = Sets.newHashSet();
            for (Operation pOp : this.planneableOps) {
                if (ops.contains(pOp)) continue;
                toRemove.add(pOp);
            }
            for (Operation op : toRemove) {
                this.planneableOps.remove(op);
            }
            for (Operation op : ops) {
                if (OperationDependencyFilter.isPlanneable(op)) {
                    if (this.planneableOps.contains(op)) continue;
                    this.planneableOps.add(op);
                    continue;
                }
                if (!this.planneableOps.contains(op)) continue;
                this.planneableOps.remove(op);
            }
            this.checkAll = false;
        }
        if (this.planneableOpsView.isEmpty()) {
            this.getScheduler().stopPlanning();
        }
        return Tuple.create(this.getDefaultSuccessor(), this.planneableOpsView);
    }

    private static boolean isPlanneable(Operation op) {
        Set<Operation> prevOps = op.getPredecessors();
        boolean isPlanneable = true;
        for (Operation prevOp : prevOps) {
            if (prevOp.isPlanned()) continue;
            isPlanneable = false;
            break;
        }
        return isPlanneable;
    }

    @Override
    public void onOperationPlanned(Operation op) {
        Set<Operation> succOps = op.getSuccessors();
        long opStart = Util.getFirstPlannedAa(op).getStart();
        for (Operation sop : succOps) {
            sop.updateSimpleBound(this, opStart);
        }
    }
}

